#!/usr/bin/perl
##########################################################################################
#					CHAT.CGI 1.6				       	 #
##########################################################################################
# Script By:						       		       		 #
#		Nick Barwig nick@jellybeanz.com				       		 #
#		7/20/97							       		 #
#		copyright 1997 - 1998 Nick Barwig			       		 #
##########################################################################################
# Chat Script Features:			Usage:
#	private messages 			/msg [nickname] [message]
#	list who is online			/whoall
#	auto log off				automatic
#	help screen				/help
#	limited number of users			defined below
#	user logoff				/quit [message]
#	emoticon list				/cons
#	disctiption				/d [message]
#	colors/bold/italic/blinking text	/color [color(HEX or name)/blink/bold/it] [message]
##########################################################################################
# Admins can:			Usage:					 		 #
#	kick users				/kick [nickname to kick] [kick message]	 #
#	ban users				/ban [nickname to ban] [ban message]	 #
#	see who is banned			/whobanned				 #
#	un-banning				/unban [IP address]			 #
#	clear the screen			/cls					 #
##########################################################################################
# Here is what you have to do:								 #
# 1) Make a new dir in your cgi-bin and chmod 777 the dir				 #
#	(if you you use NT don't worry about permissions)				 #
# 2) Rename chat.txt to chat.cgi and copy into the dir in step 1 and chmod 777 chat.cgi	 #
# 	(if you you use NT don't worry about permissions)				 #
# 3) Make 5 directories inside the directory in step 1. They are -			 #
#	rooms, users, banned, log, private. and chmod 777 each directory.		 #
#	(if you you use NT don't worry about permissions)				 #
# 4) Go through the chat.cgi file and set all the variables to your liking.		 #
# 5) Run chat.cgi									 #
#											 #
# That should be it! Enjoy!								 #
##########################################################################################
# Define Variables

$cgi_location = 'http://linux.cqi.com.cn/~elvis/chat6/chat.cgi'; 
#===> URL to the chat script

$root = '/home/httpd/elvis/public_html/chat6'; 
#===> physical path to the chat.cgi scripts directory, 
#===> this is not the url. NO TRAILING SLASHES

@rooms = ("Doorstep","Teens","Hot_Tub","Pool","Office",
		"Library","Youth","Misc"); 
#===> chat rooms you want

#===> THE RULES AND REGULATIONS ARE AT THE BOTTOM OF THE CHAT SCRIPT!!
#===> Please change them to match your situation.
$rules = 1; # 0 = print above chat login
	    # 1 = print as a link

$lines = 15;
#===> defult lines of chat will be shown

@admins = ("elvis","nick2","nick3"); 
#===> administrators nicknames. MORE NAMES CAN BE ADDED just continue the pattern
@pass = ("1234","nick2_password","nick3_password"); 
#===> admins passwords, they need to correspond with order of admins or passwords
#===> will be messed up.

$title = "Oh Yeah Net Chat"; 
#===> Title of the chat
$bgcolor = "#009ABE"; 
#===> chat background color (this is for the entire chat)
$backgroundimage = ""; 
#===> chat background image (this is for the entire chat)
$text = "Black"; 
#===> chat text color (this is for the entire chat)
$alink = "Black"; 
#===> chat active link color (this is for the entire chat)
$vlink = "Black"; 
# chat visited link color (this is for the entire chat)

$loginheader = "<CENTER><font size=5>Chat Login</font></CENTER>"; 
#===> login screen header shows what ever you want at the top of the login screen
$loginfooter = ""; 
#===> login screen footer shows what ever you want at the bottom of the login screen

$chatheader = ""; 
#===> header of the chat screen shows what ever you want at the top of the chat screen
$chatfooter = ""; 
#===> footer of the chat screen shows what ever you want at the bottom of the chat screen

$html = 'no'; 
#===> yes = html tags are allowed
#===> no = html tags are filtered out

$adminhtml = 'yes'; 
#===> yes = admins allowed html tags even though $html is set to no (this bypasses $html for admins)
#===> no = admins cannot use html tags

$idle = 300; 
#===> seconds of idle allowed before getting kicked
$msg_time = 200; 
#===> seconds private messages stay before they are deleted

$maxusers = 100; 
#===> max users allowed on a one time

$os = 'unix'; 
#===> what operating system are u using? unix or win
#      ާ@tΪܡAbոխnאּ win

$amc = "Red"; 
#===> automatic message color
$amc_size = 2; 
#===> font size of $amc

$loops = 10; 
#===> how many times the script is run before checking idle time, 
#===> this helps loading time
#===> and also doesn't bog down the server as much.

@unwanted_name_char = ('  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,
			'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,
			'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,
			'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,
			'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  ,'  );
#===> These are characters you do not want in the nickname. Pleas add others if you like.

##########################################################################################
##########################################################################################
# make sure that the main directory and all the sub-directories
# have chmod 777 permissions on them!!!!!
##########################################################################################
# done. there should be nothing else to edit
# Please report any problems or suggestions to nick@jellybeanz.com
##########################################################################################
# set and check things

print "Content-type: text/html\n\n";
$bypass = 0;
$q = $ENV{'QUERY_STRING'};
$| = 1;
$errors = "";
&check_ban;
$adminchat = 0;

if ($q =~ /help/ ){ &printhelp; }
##########################################################################################
# print logon screen
if ($q =~ "rules" || @ARGV[0] =~ "rules"){
	print "<HTML><TITLE>$title : Chat Guidlines</TITLE>\n";
	print "<BODY BACKGROUND=\"$backgroundimage\" BGCOLOR=\"$bgcolor\" TEXT=\"$text\" ALINK=\"$alink\" VLINK=\"$vlink\"><center>\n";
	&print_rules;
	exit 0;
}

if ($q =~ "login" || $ENV{'CONTENT_LENGTH'} eq ""){
	print "<HTML><TITLE>$title : LOGIN</TITLE>\n";
	print "<BODY BACKGROUND=\"$backgroundimage\" BGCOLOR=\"$bgcolor\" TEXT=\"$text\" ALINK=\"$alink\" VLINK=\"$vlink\">\n";
	print "$loginheader<p>\n";
	if ($rules eq 0){
	&print_rules;
	}elsif ($rules eq 1){
	print "<center><a href=\"$cgi_location?rules\">Chat Guidlines</a><p>\n</center>";
	}
	print "<CENTER>\n";
	print "<FORM ACTION=\"$cgi_location\" METHOD=POST>\n";
	print "<b><TABLE BORDER=0><TR><TD><b><p align=right>\n";
	print "Room:</TD>\n";
	print "<TD bgcolor=Black> <SELECT NAME=\"room\">\n";
	foreach $key (@rooms){
		print "<OPTION VALUE=\"$key\">$key</OPTION>\n";
	}
	print "</SELECT>\n";
	print "</TD></TR>\n";
	print "<TR><TD><B><p align=right>\n";
	print "Nickname:</TD> <TD bgcolor=Black><CENTER><INPUT TYPE=TEXT SIZE=20 NAME=\"nickname\" MAXLENGTH=15></TD></TR>\n";
	print "<TR><TD></TD><TD bgcolor=Black><!-CENTER->\n";
	print "<INPUT TYPE=SUBMIT VALUE=\"Enter Chat\"><INPUT TYPE=HIDDEN NAME=\"new\" VALUE=\"yes\">\n";
	print "</TD></TR>\n";
	print "</TABLE>\n";
	print "</FORM>\n";
	print "</CENTER>\n";
	print "$loginfooter\n";
	exit;
}


##########################################################################################
# read form data

read(STDIN, $input,$ENV{'CONTENT_LENGTH'});
@pairs = split(/&/, $input);
foreach $pair (@pairs) {
	($name, $value) = split(/=/, $pair);
	$name =~ tr/+/ /;
	$name =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
	$value =~ tr/+/ /;
	$value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
	$IN{$name} = $value;
}
$IN{'mesg'} =~ s/&lt;//;
$IN{'mesg'} =~ s/&gt;//;
$IN{'mesg'} =~ s/&quot;//;
##########################################################################################
# check to see if the name is reserved for admin and if it is ask for the password

$i = 0;
foreach $key (@admins){
	if ($IN{'nickname'} eq $key && $IN{'pass'} eq @pass[$i]){
		$adminchat = 1;
	}elsif ($IN{'nickname'} eq $key && $adminchat ne @pass[$i]){
		print "<BODY BACKGROUND=\"$backgroundimage\" BGCOLOR=\"$bgcolor\" TEXT=\"$text\" ALINK=\"$alink\" VLINK=\"$vlink\" onLoad=\"document.forms\[0\].pass.focus(0)\">\n";
		print "Your nickname is reserved for a chat room admin, you need a password to access the admin controls\n";
		print "<FORM ACTION=\"$cgi_location\" METHOD=POST>\n";
		print "<INPUT TYPE=HIDDEN NAME=\"nickname\" VALUE=\"$IN{'nickname'}\">\n";
		print "<INPUT TYPE=HIDDEN NAME=\"room\" VALUE=\"$IN{'room'}\">\n";
		print "<INPUT TYPE=PASSWORD NAME=\"pass\">\n";
		print "<INPUT TYPE=HIDDEN NAME=new VALUE=yes>\n";
		print "<INPUT TYPE=SUBMIT value=ENTER>\n";
		print "</FORM>\n";
		exit 0;
	}
	$i++;
}

##########################################################################################
# HTML filter
if ($html =~ 'no' && $adminchat ne 1){
	&htmlfilter;
}elsif ($adminhtml eq 'no'){
	&htmlfilter;
}
##########################################################################################
# check to see how many users are on
if ($IN{'new'} eq 'yes'){
	open(MAX,"$root/names.txt");
	@total = <MAX>;
	close(MAX);
	$e = 0;
	foreach $line (@total){
	$e++;
	}
	if ($e >= $maxusers && $adminchat ne 1){
		print "$chatheader\n<br>Sorry, to many users on at the moment. Please try again later";
		exit 0;
	}
}
&error_nickname unless $IN{'nickname'};

##########################################################################################
# CHECK IF NAME ALREADY USED

if ($IN{'new'} eq 'yes'){
	if (!(open(CHECK,"$root/users/$IN{'nickname'}.txt"))){ print; }else{ &repeat_name; exit 0; }
	close(CHECK);
}

&date;
##########################################################################################
# if its a new user log them on

if ($IN{'new'} eq 'yes'){&login;}

$IN{'mesg'} =~ s/&lt;//;
$IN{'mesg'} =~ s/&gt;//;
$IN{'mesg'} =~ s/&quot;//;
##########################################################################################
# Get the users info out of there file
open(USERINFO,"$root/log/$IN{'nickname'}.txt");
$user_info = <USERINFO>;
close(USERINFO);
($nickname, $room, $remote_host, $remote_addr) = split(/\|\"\'\|/, $user_info);

&check_kick;
##########################################################################################
# if the user wants to change rooms do that first
if ($IN{'new'} ne 'yes'){
if ($IN{'room'} ne $IN{'changeroom'}){
&change_rooms;
}
}

##########################################################################################
# reset idle time
open(WRDATE,">$root/log/$IN{'nickname'}.txt");
	print WRDATE "$time";
close(WRDATE);

################################################################################
# find out who has been idling for to long and get rid of them

open(COUNTS,"$root/count.txt");
	$counts = <COUNTS>;
close(COUNTS);

open(COUNTS2,">$root/count.txt");
	$counts++;
	print COUNTS2 $counts;
close(COUNTS2);

if ($loops <= $counts){
	open(CCOO,">$root/count.txt");
		print CCOO "0";
	close(CCOO);
	
	if (!(opendir(STAT,"$root/log"))){ print "DIRECTORY READING ERROR<BR>\n"; }
		@dir = readdir(STAT);
	closedir(STAT);

	foreach $line (sort @dir){
	if ($line ne '.' && $line ne '..'){
		$line =~ s/.txt*//;

		open(USER,"$root/log/$line.txt");
			$userr = <USER>;
		close(USER);

		$check = $time-$userr;

		if ($check >= $idle){
			open(DELL,"$root/names.txt");
				@this = <DELL>;
			close(DELL);

			open(USERS,"$root/users/$line.txt");
				$otuser = <USERS>;
			close(USERS);

			@nickrooms = split(/\|\"\'\|/, $otuser);
			$nicks = @nickrooms[0];
			$rooms = @nickrooms[1];

			open(DE,">$root/names.txt");
			foreach $namer (@this){
				if ($namer =~ /$nicks \($rooms\)/){ print DE; 
				}else{
				print DE $namer;
				}
			}
			close(DE);

			unlink ("$root/log/$line.txt");
			unlink ("$root/users/$line.txt");
			unlink ("$root/private/$line.txt");
			&chopline($rooms.txt);
			open(RE,">>$root/rooms/$rooms.txt");
			print RE "***<FONT COLOR=\"$amc\" SIZE=\"$amc_size\"><B>$nicks</b> has been kicked for idle time.</FONT>\n";
			close(RE);
		}

		}
	
	}


}
if ($IN{'mesg'} eq ""){ &print_chat; exit 0; }
##########################################################################################
# split up the message
@messsage = split(/ /,$IN{'mesg'});
# get the first word, this is done so people can type a command not for the fisrt 
# word so it will show in the chat.
$message_cmd = $messsage[0];
# UNIVERSAL COMMANDS
##########################################################################################
# quit chat

if ($message_cmd =~ /\/[qQ][uU][iI][tT]/){
	@info = split(/ /,$IN{'mesg'});
	open(OT,"$root/names.txt");
	$this = <OT>;
	close(OT);
	unlink("$root/log/$IN{'nickname'}.txt");
	unlink("$root/users/$IN{'nickname'}.txt");
	unlink("$root/private/$IN{'nickname'}.txt");
	print "<BODY BACKGROUND=\"$backgroundimage\" BGCOLOR=\"$bgcolor\" TEXT=\"$text\" ALINK=\"$alink\" VLINK=\"$vlink\">\n";
	print "You have Logged Out<br><a href=\"$cgi_location\">Relogin</a>";

	open(OUT,">$root/names.txt");
	$this = s/<B>$IN{'nickname'} \($IN{'room'}\)<\/B>//;
	print OUT $this;
	close(OUT);
	$to =1;

	open(RO,">>$root/rooms/$IN{'room'}.txt");
	print RO "***<FONT COLOR=\"$amc\" SIZE=\"$amc_size\"><B>$IN{'nickname'}</B> has signed off! (<B>";
	$it = 0;
	foreach $word (@info){
		if ($it ne 0){
		print RO "$word ";
		}
		$it++;
	}
	print RO "</B>)</FONT>\n";
	close(RO);
	&chopline($IN{'room'}.txt);
	$bypass = 1;
	exit;
##########################################################################################
# Show all people online
}elsif ($message_cmd =~ /\/([wW][hH][oO][aA][lL][lL])/){
	open(NAMEZ,"$root/names.txt");
	@names2 = <NAMEZ>;
	close(NAMEZ);
	print $chatheader;
	print "<HTML><BODY BACKGROUND=\"$backgroundimage\" BGCOLOR=\"$bgcolor\" TEXT=\"$text\" ALINK=\"$alink\" VLINK=\"$vlink\" onLoad=\"document.forms[0].mesg.focus()\">\n";
	print "<TITLE>$title : WHOALL</TITLE>\n";
	print "Whoall<br>\n Nickname (Room)<br><HR>";
	$c = 0;
	print @names2;
	$c=0;
	foreach $line (@names2){$c++;}
	if ($c == 1){
	print "<BR> You are the only person on the chat!";
	} else {
	print "<br> There are $c persons on the chat.<br>\n";
	}
	print "<HR>";
	&chat_footer;
	exit;

##########################################################################################
# send a private message
}elsif ($message_cmd =~ '/[mM][sS][gG]'){
	@msg = split(/ /,$IN{'mesg'});
	if (!(open(PRIVET,"$root/private/@msg[1].txt"))){
		$errors =  "Sorry @msg[1] does not exist<br>\n";
		close(PRIVET);
	}else{
	close(PRIVET);
	open(PRIVE,">$root/private/@msg[1].txt");
	print PRIVE "<!--&+&$time&+&--><B>$IN{'nickname'} ($ENV{'REMOTE_ADDR'}):</b>";
	$count = 0;
	push(@sndmsg,"<b>-->\[@msg[1]\] ");
	foreach $key (@msg){
		if ($count ne 0 && $count ne 1){
			print PRIVE "@msg[$count] ";
			push(@sndmsg,"@msg[$count] ");
		}
		$count++;
	}
	print PRIVE " <!--::-->\n";
	push(@sndmsg,"</b>\n");
	close(PRIVE);

	}
	$bypass = 1;
##########################################################################################
# flush private messages
}elsif ($message_cmd =~ '/[fF][lL]'){
	open(CL,">$root/private/$IN{'nickname'}.txt");
		print CL;
	close(CL);
	$errors = "Message buffer has been flushed.";
	$bypass = 1;
##########################################################################################
# show help screen
}elsif ($message_cmd =~ '/[hH][eE][lL][pP]'){
print "<HTML><BODY BACKGROUND=\"$backgroundimage\" BGCOLOR=\"$bgcolor\" TEXT=\"$text\" ALINK=\"$alink\" VLINK=\"$vlink\" onLoad=\"document.forms\[0\].mesg.focus(0)\">\n";
	print "$chatheader\n";
	print "Instructions<br><hr>\n";
	print "Commands for all users:<p>\n";
	print "<BLOCKQUOUTE>\n";
	print "<B>/msg [nickname] [message]</B> -- Sends a private message to a user<BR>\n";
	print "<B>/whoall</B> --  Displays all users logged in the entire chat<br>\n";
	print "<B>/color [HEX or color name or BOLD, ITALIC, BLINK] [message]</B> --  Displays text in colors/bold/italics/blinking<br>\n";
	print "<B>/d [message]</B> --  Shows a discription of the person<br>\n";
	print "<B>/nick [newnick]</B> --  Changes your nick name<BR>\n";
	print "<B>/quit [quit message]</B> -- Log off PLEASE USE THIS<br>\n";
	print "<B>/fl</B> -- Flushes private messages<br>\n";
	print "<B>/cons</b> -- Displays a gallery of emoticons<BR>\n";
	print "<br>\n";
	print "Commands for admins:<p>\n";
	print "<B>/cls</B> -- Clears the screen<BR>\n";
	print "<B>/kick [nickname]</B> -- Kick a specific user off the chat<BR>\n";
	print "<B>/ban [nickname]</B> -- Ban a specific IP form entering the chat<BR>\n";
	print "<B>/send [message]</b> -- Sends an anouncement to all the chat rooms<BR>\n";
	print "<p></BLOCKQUOTE>\n";
	print "<hr>\n";
	&chat_footer;
	exit 0;

##########################################################################################
# if the user wants to see the emoticons

}elsif ($message_cmd =~ '/[cC][oO][nN][sS]'){
print "<HTML><BODY BACKGROUND=\"$backgroundimage\" BGCOLOR=\"$bgcolor\" TEXT=\"$text\" ALINK=\"$alink\" VLINK=\"$vlink\" onLoad=\"document.forms\[0\].mesg.focus(0)\">\n";
print "$chatheader\n";

print <<___END___;

<b>Emoticon or smiley</b>
<hr>
<p>A symbol to compensate for the absence of nonverbal clues
when communicating on the Internet.
<pre>


 :-)   Basic smiley                 :^)   Smiley with a personality
 :)    Midget smiley               <:-l   Dunce smiley
 ,-)   Winking happy smiley         :=)   Orangutan smiley
 (-:   Left hand smiley            >:->   Devilish smiley
(:-)   Smiley big face             >:-l   Klingon smiley
(:-(   Very unhappy smiley         \@:-)   Smiley wearing a turban
 ,-}   Wry and winking smiley      \@:-}   Smiley just back from the hairdresser
 8-O   Omigod                     C=:-)   Chef smiley
 '-)   Winking smiley              X:-)   Little kid with a propeller beanie
 :-#   My lips are sealed          [:-)   Smiley wearing a walkman
 :-*   Kiss                        [:]    Robot smiley
 :-/   Skeptical smiley            {:-)   Smiley wears a toupee
 :->   Sarcastic smiley             l^o   Hepcat smiley
 :-@   Screaming smiley            }:^#)  Pointy nosed smiley
 :-d   Said with a smile            :-(=) Bucktooth smiley
 :-V   Shouting smiley              O-)   Message from cyclops
 :-X   A big wet kiss               :-3   Handlebar mustache smiley
 :-\   Undecided smiley             : =   Beaver smiley
 :-]   Smiley blockhead             :-"   Whistling smiley
 ;-(   Crying smiley                P-(   Pirate smiley
>;->   A very lewd remark was just made
 ;^)   Smirking smiley              ?-(   Black eye
 %-)   Smiley after staring at a screen for 15 hours straight
):-(   Nordic smiley               d:-)   Baseball smiley
3:]    Lucy my pet dog smiley       :8)   Pigishsmiley
 :-&   Tongue tied                  :-7   Smirking smiley
8:-)   Little girl smiley          ):-)   Impish smiley
 :-)8< Big girl smiley              :/\)  Extremely bignosed smiley
 :-0   Talkaktive smiley          8(:-)   Mickey Mouse
 :-6   Smiley after eating something spicy
+:-)   Priest smiley                ([(   Robocop
O:-)   Angel smiley                 :-(*) That comment made me sick
 :-<   Walrus smiley                &-l   That made me cry
 :-?   Smiley smokes a pipe         :-e   Disappointed smiley
 :-E   Bucktoothed vampire          :(    Sad-turtle smiley
 :-F   Bucktoothed vampire with one tooth missing
 :-Q   Smoking smiley               :,(   Crying smiley
 :-}X  Bow tie-wearing smiley       :-P   Nyahhhh!
 :-[   Vampire smiley               :-S   What you say make no sense
 :-a   Smiley touching her tongue to her nose
 :-{   Mustache                     :-C   Real unhappy smiley
 :-{}  Smiley waers lipstick        :-r   Smiley raspberry
 :-t   Pouting smiley               :-W   Speak with forked tongue
 X-(   You are brain dead           l-O   Smiley is yawing
l:-O   Flattop loudmouth smiley     $-)   Yuppie smiley
 :-!   Foot in mouth                :---) You lie like pinnochio
 O-)   Smiley after smoking a banana
=:-)   Smiley is a punk            =:-(   Real punk never smiles
3:[    Pitbull smiley             8<:-)   Smiley is a wizard
 :#)   Drunk smiley                 8-#   Dead smiley
 B-)   Smiley wears glasses         |-(   Smiley lost his contact lenses
 8-)   Smiley with big eye... perhaps wearing contact lenses...
 H-)   Cross-eyed smiley	    :-)` drooling
 ]-I   Smiley wearing sunglasses (cool, therefore no smile, only a smark!)
 V^J   Smiley with glasses, seen from the left side (tip head on right to see)
 +-(   Smiley, shot between the eyes
~:-P   Smiley with one single hair
 BI    A frog

</pre>

___END___

print "<HR>";
&chat_footer;
exit 0;

}elsif ($message_cmd =~ '/[dD]'){
	&chopline($IN{'room'}.txt);
	open(ROOM,">>$root/rooms/$IN{'room'}.txt");
	print ROOM "<B>* $IN{'nickname'}</B>";
	$IN{'mesg'} =~ s/\/[dD]//;
	print ROOM "$IN{'mesg'}\n";
	close(ROOM);
	$bypass=1;
}elsif ($message_cmd =~ '/[cC][oO][lL][oO][rR]'){
	&chopline($IN{'room'}.txt);
	
	open(COLOR,">>$root/rooms/$IN{'room'}.txt");
	$abc = @messsage[1];
	if ($abc eq ""){
		$errors = "You need to provide a color.";
		$bypass = 1;
	}else{
	if ($abc =~ /[bB][oO][lL][dD]/){
		print COLOR "<B>[$IN{'nickname'}]</B> <B>";
	}elsif ($abc =~ /[iI][tT][aA][lL][iI][cC]/){
		print COLOR "<B>[$IN{'nickname'}]</B> <I>";
	}elsif ($abc =~ /[bB][lL][iI][nN][kK]/){
		print COLOR "<B>[$IN{'nickname'}]</B> <BLINK>";
	}else{
		print COLOR "<B>[$IN{'nickname'}]</B> <FONT COLOR=\"@messsage[1]\">";
	}
	$t = 0;
	foreach $thing (@messsage){
		if ($t eq 0 || $t eq 1){ print; }else{ print COLOR "$thing ";
		}
	$t++;
	}
	if ($abc =~ /[bB][oO][lL][dD]/){
		print COLOR "</B>\n";
	}elsif ($abc =~ /[iI][tT][aA][lL][iI][cC]/){
		print COLOR "</I>\n";
	}elsif ($abc =~ /[bB][lL][iI][nN][kK]/){
		print COLOR "</BLINK>\n";
	}else{
		print COLOR "</FONT>\n";
	}
	close(COLOR);
	$bypass=1;
	}
}elsif ($message_cmd =~ /\/[nN][iI][cC][kK]/){
	$newnick = @messsage[1];
	$newnick =~ s/ /_/g;
        $newnick =~ s/!/_/g;
        $newnick =~ s/'/_/g;
        $newnick =~ s/"/_/g;
        $newnick =~ s/</_/g;
        $newnick =~ s/>/_/g;
        $newnick =~ s/\&/_/g;
        $newnick =~ s/\(/_/g;
        $newnick =~ s/\)/_/g;
        $newnick =~ s/\$/_/g;

 	foreach $key (@unwanted_name_char){
 	$newnick =~ s/$key/_/;
 	}
	foreach $key (@admins){
		if ($newnick eq $key){
			$errors = "Sorry, $newnick is reserved for an admin";
		}
	}
 	
	if ($adminchat == 1){
	$errors = "Sorry, admins need to keep their nicknames<br>\n";
	}elsif ($errors eq ""){
	
	if (open(yd,"$root/users/$newnick.txt")){
		$errors = "Sorry, $newnick already in use";
		close(yd);
	}else{
	close(yd);

        rename("$root/users/$IN{'nickname'}.txt","$root/users/$newnick.txt");
	rename("$root/log/$IN{'nickname'}.txt","$root/log/$newnick.txt");
	rename("$root/private/$IN{'nickname'}.txt","$root/private/$newnick.txt");
	open(CHANGENICK,">$root/users/$newnick.txt");
	print CHANGENICK "$newnick\|\"\'\|$IN{'room'}\|\"\'\|$ENV{'REMOTE_HOST'}\|\"\'\|$ENV{'REMOTE_ADDR'}\n";
	close(CHANGENICK);
	open(NICKNAMES,"$root/names.txt");
	@nikx = <NICKNAMES>;
	close(NICKNAMES);
	open(NICZ,">$root/names.txt");
	foreach $line (@nikx){
	if ($line =~ /$IN{'nickname'} \($IN{'room'}\)/){
		print NICZ "<B>$newnick ($IN{'room'})</B><BR>\n";
	}else{
		print NICZ $line;
	}
	}
	close(NICZ);
	&chopline($IN{'room'}.txt);
	open(ROOM,">>$root/rooms/$IN{'room'}.txt");
	print ROOM "***<FONT COLOR=\"$amc\" SIZE=\"$amc_size\"><B>$IN{'nickname'}</B> is now known as <B>$newnick</B></FONT>\n";
	close(ROOM);
	$IN{'nickname'} = $newnick;
	}
	
	}
	$bypass = 1;
}
	

# ADMIN STUFF
##########################################################################################
# kick control
if ($message_cmd =~ '/[kK][iI][cC][kK]' && $adminchat==1){
	@kick = split(/ /,$IN{'mesg'});
	if (!(open(KICKUSER,"$root/users/@kick[1].txt"))){
		$errors = "USER @kick[1] NOT FOUND<BR>";
		$bypass = 1;
		close(KICKUSER);
	}else{
	close(KICKUSER);
	open(USERINFO,"$root/log/@kick[1].txt");
	$user_info2 = <USERINFO>;
	close(USERINFO);
	@userstuff2 = split(/\|\"\'\|/, $user_info2);
	open(DELL,"$root/names.txt");
		$this = <DELL>;
	close(DELL);
	open(DE,">$root/names.txt");
	$this =~ s/<B>@kick[1] \(@userstuff2[1]\)<\/B><BR>//;
	print DE $this;
	close(DE);
	unlink("$root/log/@kick[1].txt");
	unlink("$root/users/@kick[1].txt");
	unlink("$root/private/@kick[1].txt");
	&chopline($IN{'room'}.txt);
	open(SHOW,">>$root/rooms/$IN{'room'}.txt");
		print SHOW "***<FONT COLOR=\"$amc\" SIZE=\"$amc_size\"><B>@kick[1]</b> has been kicked by $IN{'nickname'}!</FONT>\n";
	close(SHOW);
		$bypass = 1;
}

##########################################################################################
# if the user is not an admin don't let him kick out any one
}elsif ($message_cmd =~ '/[kK][iI][cC][kK]' && $adminchat ne 1){
	$errors = "Sorry you are not an admin<br>";
	$bypass = 1;	

##########################################################################################
# ban users
}elsif ($message_cmd =~ '/[bB][aA][nN]' && $adminchat==1){
	@banwho = split(/ /,$IN{'mesg'});
	if (!(open(IP,"$root/users/$banwho[1].txt"))){
		$errors = "USER @banwho[1] NOT FOUND<BR>";
		close(IP);
	}else{
	$ips = <IP>;
	close(IP);
	@ip = split(/\|\"\'\|/,$ips);

	open(BAN,">>$root/banned/ban.txt");
	print BAN "@ip[3]\n";
	close(BAN);
	&chopline($IN{'room'}.txt);
	open(ROOM,">>$root/rooms/$IN{'room'}.txt");
		print ROOM "***<FONT COLOR=\"$amc\" SIZE=\"$amc_size\"><B>$banwho[1]</B> has been banned by <B>$IN{'nickname'}</B></FONT>\n";
	close(ROOM);
	unlink("$root/users/@banwho[1].txt");
	unlink("$root/log/@banwho[1].txt");
	unlink("$root/private/@banwho[1].txt");
	open(DED,"$root/names.txt");
	@nick = <DED>;
	close(DED);
	open(DE, ">$root/names.txt");
	foreach $line (@nick){
		if ($line =~ /<B>@banwho[1] \(@ip[1]\)<\/B><BR>/){
		print DE;
		}else{
		print DE $line;
		}
	}
	close(DE);
	}
	$bypass = 1;

##########################################################################################
# if the user is not an admin don't let him ban anyone
}elsif ($message_cmd =~ '/[bB][aA][nN]' && $adminchat ne 1){
	$errors = "Sorry you are not an admin<br>";
	$bypass = 1;
##########################################################################################
# see ip addressed banned
}elsif ($message_cmd =~ '/[wW][hH][oO][bB][aA][nN]' && $adminchat == 1){
	open(WHOBAN,"$root/banned/ban.txt");
	@banned = <WHOBAN>;
	close(WHOBAN);
	print "<HTML><BODY BACKGROUND=\"$backgroundimage\" BGCOLOR=\"$bgcolor\" TEXT=\"$text\" ALINK=\"$alink\" VLINK=\"$vlink\" onLoad=\"document.forms\[0\].mesg.focus(0)\">\n";
	print "<B>Who is banned</B><br><hr><BR>\n";
	foreach $line (@banned){
		print "$line<BR>\n";
	}
	print "<HR>";
	&chat_footer;
	exit 0;

##########################################################################################
# if the user is not an admin dont let him/her see who is banned
}elsif ($message_cmd =~ '/[wW][hH][oO][bB][aA][nN]' && $adminchat ne 1){
	$errors = "Sorry, you are not an admin,<br>\n";
	$bypass = 1;

##########################################################################################
# unban an IP address
}elsif ($message_cmd =~ '/[uU][nN][bB][aA][nN]' && $adminchat == 1){
	@unban = split(/ /, $IN{'mesg'});
	open(UNB,"$root/banned/ban.txt");
	$unb = <UNB>;
	close(UNB);
	open(UNBAN,">$root/banned/ban.txt");
	$unb =~ s/@unban[1]//;
	print UNBAN $unb;
	close(UNBAN);
	print "@unban[1] has been taken off the banned list<br>\n";
	$bypass = 1;

##########################################################################################
# if the user is not an admin dont let him unban an IP
}elsif ($message_cmd =~ '/[uU][nN][bB][aA][nN]' && $adminchat ne 1){
$errors = "Sorry, you are not an admin.<BR>\n";
	$bypass = 1;

##########################################################################################
# clear the screen
}elsif ($message_cmd =~ '/[cC][lL][sS]' && $adminchat == 1){
	open(CLEAR,">$root/rooms/$IN{'room'}.txt");
		print CLEAR "***<FONT COLOR=\"$amc\" SIZE=\"$amc_size\">Screen has been cleared by <B>$IN{'nickname'}</B></font>\n";
	close(CLEAR);
	$bypass = 1;
}elsif ($message_cmd =~ '/[cC][lL][sS]' && $adminchat ne 1){
$errors = "Sorry, you are not an admin";
$bypass = 1;

##########################################################################################
# all chat room announcement
}elsif ($message_cmd =~ '/[sS][eE][nN][dD]' &&$adminchat == 1){
	$nounce = $IN{'mesg'};
	$nounce =~ s/\/send//;
	foreach $key (@rooms){
		open(SEND,">>$root/rooms/$key.txt");
		$u = 0;
		print SEND "<b>*ANNOUCEMENT BY $IN{'nickname'}*</b><i>";
		print SEND "$nounce";
		print SEND"</i>\n";
		close(SEND);
	}
$bypass = 1;
}elsif ($message_cmd =~ '/[sS][eE][nN][dD]' &&$adminchat ne 1){
$errors = "Sorry, you are not an admin";
$bypass = 1;
}


##########################################################################################
# if there is a message post it
if ($bypass == 1){ # if the user typed a command don't print it
	&print_chat;
}
if ($IN{'mesg'} ne ""){ # if the user typed a message print it in the chat room
	open(ADD,">>$root/rooms/$IN{'room'}.txt");
		print ADD "<b>[$IN{'nickname'}]</b> $IN{'mesg'}\n";
	close(ADD);
}
&print_chat;

sub printhelp {
	print "<HTML><BODY BACKGROUND=\"$backgroundimage\" BGCOLOR=\"$bgcolor\" TEXT=\"$text\" ALINK=\"$alink\" VLINK=\"$vlink\">\n";
	print "$chatheader\n";
	print "Instructions<br><hr>\n";
	print "Commands for all users:<p>\n";
	print "<BLOCKQUOUTE>\n";
	print "<B>/msg [nickname] [message]</B> -- Sends a private message to a user<BR>\n";
	print "<B>/whoall</B> --  Displays all users logged in the entire chat<br>\n";
	print "<B>/color [HEX or color name or BOLD, ITALIC, BLINK] [message]</B> --  Displays text in colors/bold/italics/blinking<br>\n";
	print "<B>/d [message]</B> --  Shows a discription of the person<br>\n";
	print "<B>/nick [newnick]</B> --  Changes your nick name<BR>\n";
	print "<B>/quit [quit message]</B> -- Log off PLEASE USE THIS<br>\n";
	print "<B>/fl</B> -- Flushes private messages<br>\n";
	print "<B>/cons</b> -- Displays a gallery of emoticons<BR>\n";
	print "<br>\n";
	print "Commands for admins:<p>\n";
	print "<B>/cls</B> -- Clears the screen<BR>\n";
	print "<B>/kick [nickname]</B> -- Kick a specific user off the chat<BR>\n";
	print "<B>/ban [nickname]</B> -- Ban a specific IP form entering the chat<BR>\n";
	print "<B>/send [message]</b> -- Sends an anouncement to all the chat rooms<BR>\n";
	print "<p></BLOCKQUOTE>\n";
	exit 0;
}
##########################################################################################
# sub routines
##########################################################################################
# print out the main part of chat
sub print_chat {
	print "<TITLE>$title : $IN{'nickname'} in chat room $IN{'room'}</TITLE>\n";
	print "<BODY BGCOLOR=\"$bgcolor\" BACKGROUND=\"$backgroundimage\" TEXT=\"$text\" ALINK=\"$alink\" VLINK=\"$vlink\" onLoad=\"document.forms[0].mesg.focus(0)\">\n";
	print "$chatheader\n\n";
	print "$IN{'nickname'} in Chat Room $IN{'room'}<br><HR>\n";
	open(CHAT,"$root/rooms/$IN{'room'}.txt");
		@chat = <CHAT>;
	close(CHAT);
	$e = 1;
	foreach $line (@chat){
		print "$line<BR>\n";
		$e++;
	}
	$r = 1;
	if ($e > $lines){
		open(RE,">$root/rooms/$IN{'room'}.txt");
		foreach $line (@chat){
			if ($r == 1){print " ";}else{
			print RE $line;
			}
			$r++;
		}
		close(RE);
	}
	print "<HR>\n";
	if ($errors ne ""){
	print "***$errors<hr>\n"
	}
	if (@sndmsg[0] ne ""){
	print "***@sndmsg<hr>\n";
	}
	&chat_footer;
	exit;
}

##########################################################################################
# print the chat footer, message box submit button, etc
sub chat_footer {
	&check_private;
	print "<FORM ACTION=\"$cgi_location\" METHOD=POST>\n";
	print "<INPUT TYPE=HIDDEN NAME=\"nickname\" VALUE=\"$IN{'nickname'}\">\n";
	print "<INPUT TYPE=HIDDEN NAME=\"room\" VALUE=\"$IN{'room'}\">\n";
	print "<INPUT TYPE=HIDDEN NAME=line VALUE=\"$lines\">\n";
	print "<INPUT TYPE=TEXT NAME=\"mesg\" SIZE=50>\n";
	print "<INPUT TYPE=SUBMIT Value=\"POST/RELOAD\">";
	if ($adminchat == 1){
		print "<INPUT TYPE=HIDDEN NAME=pass VALUE=\"$IN{'pass'}\">\n";
	}
	print "<SELECT NAME=\"changeroom\" onChange=\"document.forms[0].submit()\">\n";
	print "<OPTION VALUE=\"$IN{'room'}\" SELECTED>$IN{'room'}\n";
	foreach $key (@rooms){
		print "<OPTION VALUE=\"$key\">$key\n";
	}
	print "</SELECT><a href=\"$cgi_location?help\">Help</a>\n";
	print "<b><BR> You have to hit POST or < ENTER > to reload the chat, I do this so it doesn't reload right in the middle of a sentence your typing</b>\n";
        print "</FORM>\n";
	print $chatfooter;
	
}

##########################################################################################
# change rooms
sub change_rooms {
	&chopline($IN{'room'}.txt);
	open(OLDROOM,">>$root/rooms/$IN{'room'}.txt");
	@oldroom = <OLDROOM>;
	print OLDROOM "***<FONT COLOR=\"$amc\" SIZE=\"$amc_size\"><B>$IN{'nickname'}</B> has left location <B>$IN{'room'}</B></FONT>\n";
	close(OLDROOM);
	open(NICKNAMEZ,"$root/names.txt");
	@nickz = <NICKNAMEZ>;
	close(NICKNAMEZ);
	open(NI,">$root/names.txt");
	foreach $name (@nickz){
		if ($name =~ /$IN{'nickname'} \($IN{'room'}\)/){
		print NI "<B>$IN{'nickname'} \($IN{'changeroom'}\)<\/B><BR>\n";
		}else{
		print NI $name;
		}
	}

	close(NI);
	$IN{'room'} = $IN{'changeroom'};
	&chopline($IN{'room'}.txt);
	open(NEWROOM,">>$root/rooms/$IN{'room'}.txt");
	@newdroom = <OLDROOM>;
	print NEWROOM "***<FONT COLOR=\"$amc\" SIZE=\"$amc_size\"><B>$IN{'nickname'}</B> has entered the <B>$IN{'room'}</B></FONT>\n";
	close(NEWROOM);
	open(NEWSTUFF,">$root/users/$IN{'nickname'}.txt");
	print NEWSTUFF "$IN{'nickname'}\|\"\'\|$IN{'room'}\|\"\'\|$ENV{'REMOTE_HOST'}\|\"\'\|$ENV{'REMOTE_ADDR'}\n";
	close(NEWSTUFF);
}
##########################################################################################
# log the user in
sub login {
        foreach $key (@unwanted_name_char){
 	$IN{'nickname'} =~ s/$key/_/;
 	}
        $IN{'nickname'} =~ s/ /_/g;
        $IN{'nickname'} =~ s/!/_/g;
        $IN{'nickname'} =~ s/'/_/g;
        $IN{'nickname'} =~ s/"/_/g;
        $IN{'nickname'} =~ s/</_/g;
        $IN{'nickname'} =~ s/>/_/g;
        $IN{'nickname'} =~ s/\&/_/g;
        $IN{'nickname'} =~ s/\(/_/g;
        $IN{'nickname'} =~ s/\)/_/g;
        $IN{'nickname'} =~ s/\$/_/g;
	&chopline($IN{'room'}.txt);
	open(CAT,">>$root/rooms/$IN{'room'}.txt");
		print CAT "***<FONT COLOR=\"$amc\" SIZE=\"$amc_size\">New Login: <B>$IN{'nickname'}</B> has joined <B>$IN{'room'}</B></FONT>\n";
	close(CAT);

	open(PRIV, ">$root/private/$IN{'nickname'}.txt");
	print PRIVE;
	close(PRIV);
	open(CHATNAME,">$root/users/$IN{'nickname'}.txt");
		print CHATNAME "$IN{'nickname'}\|\"\'\|$IN{'room'}\|\"\'\|$ENV{'REMOTE_HOST'}\|\"\'\|$ENV{'REMOTE_ADDR'}";
	close(CHATNAME);
	open(NICK,">>$root/names.txt");
		print NICK "<B>$IN{'nickname'} ($IN{'room'})</B><BR>\n";
	close(NICK);
	open(USERLOG,">$root/log/$IN{'nickname'}.txt");
		print USERLOG $date;
	close(USERLOG);
}

##########################################################################################
# check to see of the user has been kicked from the chat
sub check_kick {
	$n = 0;
	if (!(open(NICKNAM,"$root/log/$IN{'nickname'}.txt"))){$n++}
	close(NICKNAM);
	if (!(open(NICKNAMEE,"$root/users/$IN{'nickname'}.txt"))){$n++;}
	close(NICKNAMEE);
	if ($n ne 0){
		print "<BODY BACKGROUND=\"$backgroundimage\" BGCOLOR=\"$bgcolor\" TEXT=\"$text\" ALINK=\"$alink\" VLINK=\"$vlink\">\n";
		print "SORRY, YOU HAVE BEEN KICKED OFF THE CHAT....\n<p><a href=\"$cgi_location\">Relogin</a>";
		exit 0;
	}
}

##########################################################################################
# check to see if the users IP address has been banned
sub check_ban {
	$bann = 0;
	open(BAN,"$root/banned/ban.txt");
		@banned = <BAN>;
	close(BAN);
	foreach $line (@banned){
		if ($line =~ $ENV{'REMOTE_ADDR'}){
			print "<BODY BACKGROUND=\"$backgroundimage\" BGCOLOR=\"$bgcolor\" TEXT=\"$text\" ALINK=\"$alink\" VLINK=\"$vlink\">\n";
			print "SORRY, YOU HAVE BEEN BANNED FROM THIS CHAT.";
			print "<p><a href=\"$cgi_location\">Relogin</a>";
			exit;
		}
	}
}

##########################################################################################
# see if there are private messages for the user
sub check_private {
	open(FILE,"$root/private/$IN{'nickname'}.txt");
		@contents=<FILE>;
	close(FILE);
	split(/<!--::-->/,@contents);
	$p = 0;
	foreach $key (@contents){
		print "\*\*\*$key<br>\n";
		($bog,$load,$bog2) = split(/\&\+\&/,@contents[$p]);
		if ($time - $load > $msg_time){
			$t = 0;
			open(REMOVE,">$root/private/$IN{'nickname'}.txt");
			foreach $line (@contents){
			if ($t == $p){print ""; }else{ print REOMOVE "$line\n"; }
			$t++;
			}
		}
		$p++;
	}
}

##########################################################################################
# get the time
sub date {
   ($sec,$min,$hour) = localtime(time);

   if ($sec < 10) {
      $sec = "0$sec";
   }
   if ($min < 10) {
      $min = "0$min";
   }
   if ($hour < 10) {
      $hour = "0$hour";
   }

   $date = "$hour\:$min\:$sec";
   chop($date) if ($date =~ /\n$/);

   $time = time();
   
}
##########################################################################################
# tell the user if the nickname is already in use
sub repeat_name{
	print "<TITLE>$title : ERROR</TITLE>\n";
	print "<BODY BGCOLOR=\"$bgcolor\" BACKGROUND=\"$backgroundimage\" TEXT=\"$text\" ALINK=\"$alink\" VLINK=\"$vlink\">\n";
	print "$chatheader\n\n";
	print "<BR>Sorry, $IN{'nickname'} is already in use.\n<BR>$chatfooter";
	print "<BR>\n$chatfooter\n";
}

##########################################################################################
# tell the user that he/she forget a nickname
sub error_nickname {
	print "<TITLE>$title : ERROR</TITLE>\n";
	print "<BODY BGCOLOR=\"$bgcolor\" BACKGROUND=\"$backgroundimage\" TEXT=\"$text\" ALINK=\"$alink\" VLINK=\"$vlink\">\n";
	print "$chatheader\n\n";
	print "Error: No Nickname, please <a href=\"$cgi_location\">try again</a>.\n<br>";
	print "<BR>\n$chatfooter\n";
	exit;
}

##########################################################################################
# get rid of any HTML tags created by a non-admin
sub htmlfilter
{

$IN{'mesg'} =~ s/<(IMG\s*SRC.*)>//ig;
$IN{'mesg'} =~ s/<([^>]+)>//ig;
}

sub chopline {
	$openroom = $_[0];
	open(CHAT,"$root/rooms/$openroom");
		@chater = <CHAT>;
	close(CHAT);
	$e = 1;
	foreach $line (@chater){
		$e++;
	}

	$r = 1;
	if ($e > $lines){
		open(RE,">$root/rooms/$IN{'room'}.txt");
		foreach $line (@chater){
			if ($r ne 1){
			print RE $line;
			}
			$r++;
		}
		close(RE);
		&chopline($openroom);
	}

}
##########################################################################################
# print out rules and guidlines of the chat room

sub print_rules {

# The editing of the rules must be done within the "print<<__STOP__;" and the "__STOP__", if you delete those
# tags this script will not run!

print <<__STOP__;
<font size=6>Chat Guidlines</font>
</center>
<HR>
<B>It is in our best interest to keep this chat a friendly place for the
enjoyment of everyone. This is an international forum and freedom of opinion
is supported and constructive discussion of ideas should be fostered. Foul
language and insults are not welcome and users will be kicked off or banned
from the chat for this type of behavior. Harrassment or promotion of illegal
activities is forbidden throughout the chat. <P>

Going from room to room advertising for cybersex is not allowed.
<P>

Flooding a room with annoying or duplicate messages or just random garbage is
termed flooding and is grounds for a kick or in extreme cases banning.
<p>

Reposting of private messages in public is rude and is grounds for kicking.
<p>

Use of vulgar nickname or language on the chat is prohibited warning should be
required and you do not conform you will be banned. We have many underage users on the chat
so conversation must be acceptable to all parents of such children. Please think before you type.
<p>

Words like hell, damn, pissed, or ass are acceptable unless they are used in insulting context.
<p>

The words "shit" "fuck" or thier derivatives as well as words and phrases describing
gentilia or actions performed on gentilia are not allowed.
<p>

As an example saying "my job sucks" is acceptable while using the
word "suck" in other contexts may be grounds for a kick or ban.
<p>

Hostile, insulting, or harrassing behavior is not allowed and you will be kicked
or banned from the chat. Kicking for CAPS is not allowed.
<p>

__STOP__

}
